import poser, gzip, os

from Tkinter import *
import tkFileDialog

scene = poser.Scene()


class App(object):
    def __init__(self,master):
        self.master = master
        master.title("Morph Slot Maker")

        self.fig = scene.CurrentFigure()
        self.memdict = {}
        
        libpath = "Runtime\\Libraries\\Pose"
        libpath = libpath.replace("\\",os.sep)        
        self.libdir = os.path.normpath(os.path.join(os.path.dirname(poser.AppLocation()),libpath))        

        self.masterFrame = Frame(self.master)
        self.masterFrame.grid(row=1,column=0)

        self.buttonFrame = Frame(self.masterFrame,borderwidth=2,relief=RIDGE)
        self.buttonFrame.grid(row=2,column=0)

        self.runButton = Button(self.buttonFrame,text="Run",command=self.go,padx=25)
        self.runButton.grid(row=0,column=1)

        self.quitButton = Button(self.buttonFrame,text="Quit",command=self.die,padx=25)
        self.quitButton.grid(row=0,column=2)


    def die(self):
        """ """
        root.destroy()
        root.quit()

    def go(self):        
        p = tkFileDialog.askopenfilename(initialdir=self.libdir,initialfile="Untitled.pz2",title="Open",
                                           filetypes=[("Poser .pz2 files", "*.pz2 *.PZ2 *.pzz *.PZZ")])

        if p:
            self.zero_all()
            path,ext = p.split(".")
            if ext == "pzz" or ext == "PZZ":
                f = gzip.GzipFile(p)
            else:
                f = open(p,"r")
            g = f.readlines()
            f.close()

            fig = self.fig
            fignum = fig.Actors()[0].InternalName().split(":")[1]
            figacts = [act.InternalName() for act in fig.Actors()]
            actname = None
            
            for line in g:                
                if line.find("actor\t") != -1:
                    line = line.replace("\t"," ")
                if line.find("actor ") != -1:                    
                    actname = "%s:%s" %(line.replace("actor ","").replace("\n","").replace("\r","").split(":")[0],fignum)
                    if actname in figacts:
                        act = fig.ActorByInternalName(actname)                    
                        actmorphs = []                    
                        for parm in act.Parameters():
                            if parm.IsMorphTarget():
                                actmorphs.append(parm.InternalName())
                    else:
                        actname = None
                if actname:
                    if line.find("targetGeom\t") != -1:
                        line = line.replace("targetGeom\t","targetGeom ")
                    if line.find("targetGeom ") != -1:
                        line = line.replace("\t","")
                        mt = line.replace("targetGeom ","").replace("\n","").replace("\r","")
                        if not (mt in actmorphs):                        
                            act.SpawnTarget(mt)            
            
            self.restore_all()
            figacts = []
            root.destroy()
            

    def zero_all(self):
        fig = self.fig                
            
        for act in fig.Actors():
            self.memdict[act.InternalName()] = {}
            actdict = self.memdict[act.InternalName()]
            for parm in act.Parameters():                
                if parm.TypeCode() == poser.kParmCodeASCALE or\
                   parm.TypeCode() == poser.kParmCodeXSCALE or\
                   parm.TypeCode() == poser.kParmCodeYSCALE or\
                   parm.TypeCode() == poser.kParmCodeZSCALE:
                    actdict[parm.Name()] = parm.Value()
                    parm.SetValue(1.0)
                if parm.TypeCode() == poser.kParmCodeXROT or\
                   parm.TypeCode() == poser.kParmCodeYROT or\
                   parm.TypeCode() == poser.kParmCodeZROT or\
                   parm.TypeCode() == poser.kParmCodeXTRAN or\
                   parm.TypeCode() == poser.kParmCodeYTRAN or\
                   parm.TypeCode() == poser.kParmCodeZTRAN:
                    actdict[parm.Name()] = parm.Value()
                    parm.SetValue(0.0)
                    
        for act in fig.Actors():            
            actdict = self.memdict[act.InternalName()]
            for parm in act.Parameters():                
                if parm.IsMorphTarget():
                    actdict[parm.Name()] = parm.Value()
                    parm.SetValue(0.0)

    def restore_all(self):
        fig = self.fig
        for act in fig.Actors():
            actdict = self.memdict[act.InternalName()]

            for parm in act.Parameters():
                if actdict.has_key(parm.Name()):
                    parm.SetValue(actdict[parm.Name()])

            self.memdict[act.InternalName()] = {}
        self.memdict = {}
                    

root = Tk()
app = App(root)
root.mainloop()
