import gzip, os, poser

from Tkinter import *
import tkFileDialog

scene = poser.Scene()

"""
EULA, USER LICENSE

weight_pose_applicator3g.py

DEFINITIONS.

SOFTWARE; The package you downloaded containing the weight_pose_applicator2b.py.
Distributor; Site you downloaded the package from or any of the brokers involved in the packaging and or deployment of the
weight_pose_applicator2b.py.

LICENSE. 

CageDrei hereby gives you rights to use the weight maps contained in the .py file, but retains ownership and all intellectual property and copyrights.

By using the weight_pose_applicator2b.py, you accept these terms. 
If you do not accept them, uninstall the weight_pose_applicator2b.py as outline in termination section of this agreement. 

SCOPE OF LICENSE. 

The software contained in the weight_pose_applicator2b.py file is licensed, no rights to the software is transferred to the end user. 
This agreement only gives you some rights to use the features included in the software. 
You may use the weight_pose_applicator2b.py only as expressly permitted in this agreement. 
In doing so, you must comply with this agreement and only use it in certain ways. 

YOU MAY NOT.

Reverse engineer, decompile or disassemble the weight_pose_applicator2b.py, except and only to the extent that applicable law expressly permits,
despite this limitation;

Rent, lease, distribute or resell the weight_pose_applicator2b.py file.

YOU MAY.

Use this weight_pose_applicator2b.py file for the intended purpose of creating weight mapped, rerigged figures.

TERMINATION.
  
The license will terminate automatically if you fail to comply with the limitations described above.
On termination, you must uninstall and destroy any and all physical copies of the weight_pose_applicator2b.py file.
 
DISCLAIMER OF WARRANTY.  
 
The weight_pose_applicator2b.py is provided on an AS IS basis, without warranty of any kind.  
The entire risk as to the quality and performance of the Software is borne by you.  
Should the Software prove defective, you and not CageDrei assume the entire cost of any service and repair.

CAGEDREI AND DISTRIBUTERS OF THE SOFTWARE ARE NOT RESPONSIBLE FOR ANY INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF ANY CHARACTER INCLUDING,
WITHOUT LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, COMPUTER FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES OR LOSSES.
 
Title, ownership rights and intellectual property rights in and to the weight_pose_applicator2b.py shall remain with CageDrei. 
The weight_pose_applicator2b.py is protected by international copyright treaties.  
"""

"""
HISTORY
"""

"""
INSTRUCTIONS FOR USE
"""

def load_cr2(pathDonor,pathPose,pathBones="",remove_files=0,write_to_temp=0,remove_JCM=1,remove_JSM=1,remove_mags=1):
    if float(poser.Version()) < 9.0:
        print "This script requires Poser version 9 or greater."
        return
    if (not os.path.exists(pathDonor)) or (not os.path.exists(pathPose)):
        print "One or more submitted paths is invalid.  Please try again."
        return

    app.status_update("Starting weight injection....")
    
    if write_to_temp:
        poser_temp = poser.TempLocation()
        basename = os.path.basename(pathDonor)
        pathDonor_temp = os.path.normpath(os.path.join(poser_temp,basename))
        pathDonor_temp = "%s_weighted%s" %(os.path.splitext(pathDonor_temp)[0],os.path.splitext(pathDonor_temp)[1])
    else:
        pathDonor_temp = "%s_weighted%s" %(os.path.splitext(pathDonor)[0],os.path.splitext(pathDonor)[1])
    pathDonor_temp = protect_naming(pathDonor_temp)

    app.status_update("Reading weight pose....")
    intnames, affectors = pose_reader(pathPose) # Get actor names from injection pose.  These will be processed for JCM removal

    app.status_update("Checking for settings file....")
    rules = read_datafile(pathPose,pathDonor)
    if not rules:
        keep_specific = []
        keep_general = []
    else:
        keep_specific = [i for i in rules["magnet_preserve_specific"]]
        keep_general = [i for i in rules["magnet_preserve_general"]]
        del rules["magnet_preserve_specific"]
        del rules["magnet_preserve_general"]
        

    app.status_update("Loading figure....")
    scene.LoadLibraryFigure(pathDonor) # Load donor .cr2 (to load any readScript morphs, as are used in V4)

    scene.ProcessSomeEvents(1)
    scene.DrawAll()   

    if intnames[0].find(":") != -1:
        pose_fignum = intnames[0].split(":")[1]
    for act in scene.CurrentFigure().Actors():        
        if act.IsBodyPart():
            fig_fignum = act.InternalName().split(":")[1]
            break
    for i in range(len(intnames)):
        line = intnames[i]
        if line.find(":") != -1:
            intnames[i] = line.replace(":%s" %(pose_fignum),":%s" %(fig_fignum))
        else:
            intnames[i] = "%s:%s" %(line,fig_fignum)
    if remove_mags:
        excludes = []
        for act in scene.CurrentFigure().Actors():
            if act.IsBodyPart():            
                if not act.InternalName() in intnames:
                    if not act.InternalName() in excludes:
                        excludes.append(act.InternalName())
        
        app.status_update("Removing magnets....")
        deleteMags(scene.CurrentFigure(),excludes,keep_specific=keep_specific,keep_general=keep_general) # Delete figure magnets

    scene.ProcessSomeEvents(1)
    scene.DrawAll()

    app.status_update("Saving figure to library....")
    scene.SaveLibraryFigure(pathDonor_temp) # Save figure back to library under a new name; this cr2 will be edited and loaded by the loader cr2
    app.status_update("Removing figure from scene....")
    scene.DeleteCurrentFigure() # Delete this temporary figure

    scene.ProcessSomeEvents(1)
    scene.DrawAll()

    if not os.path.exists(pathDonor_temp):
        print "Poser was unable to save the figure back to Libraries:Characters."
        print "Please check your settings and permissions and try again."
        return
    
    fig = figure()
    app.status_update("Trimming saved cr2....")    
    merger(pathDonor_temp,fig,useWeights=0,useJoints=0,useAffects=1,remove_JCM=remove_JCM,remove_JSM=remove_JSM,affectors=affectors,replace_fignum=0,intnames=intnames,rules=rules,addBlock=0)

    if pathBones:
        app.status_update("Loading additional actors from pose....")
        merger(pathBones,fig,useWeights=0,useJoints=0,useAffects=0,remove_JCM=0,remove_JSM=0,affectors=None,replace_fignum=1,intnames=None,rules=None,addBlock=0)
    
    app.status_update("Merging weight injection data into figure....")
    merger(pathPose,fig,useWeights=1,useJoints=1,useAffects=1,remove_JCM=1,remove_JSM=1,affectors=None,replace_fignum=1,intnames=None,rules=None,addBlock=1)

    app.status_update("Path = %s" %(pathDonor_temp))
    writer(pathDonor_temp,fig)

    if not os.path.exists(pathDonor_temp):
        print "There was an error writing the edited cr2 to the selected location."
        print "Please check your settings and permissions and try again."
        return

    app.status_update("Loading new figure....")
    scene.LoadLibraryFigure(pathDonor_temp) # Load the weight injection pose loader .cr2.  This will load the figure and apply the weights.      

    app.status_update("Removing temp files....")
    if remove_files:
        os.remove(pathDonor_temp) # Delete cr2 saved back to library.
        os.remove("%s.png" %(os.path.splitext(pathDonor_temp)[0])) # Delete library save .png file.
    
    excludes = intnames = affectors = []
    app.status_update("Done!")

def read_datafile(pathPose,pathDonor):
    """
    applicatorSetting=targetGeom_delete
    applicatorSetting=targetGeom_preserve
    applicatorSetting=valueParm_delete
    applicatorSetting=valueParm_preserve
    applicatorSetting=magnet_preserve_specific
    applicatorSetting=magnet_preserve_general
    applicatorSetting=figname_append
    applicatorSetting=figname_replace
    """
    path = os.path.normpath(os.path.splitext(pathPose)[0].replace("_weight_pose","_settings.txt"))    
    if not os.path.exists(path): # Check weight pose location
        path = os.path.normpath( os.path.splitext(os.path.join(os.path.dirname(poser.ScriptLocation()),os.path.basename(pathPose)))[0].replace("_weight_pose","_settings.txt") )        
        if not os.path.exists(path): # Check script location
            dirname = os.path.dirname(pathDonor)
            name = os.path.splitext(os.path.basename(pathPose))[0].replace("_weight_pose","_settings.txt")
            path = os.path.normpath(os.path.join(dirname,name))            
            if not os.path.exists(path): # Check target cr2 location
                app.status_update("No data file found for this pose.")
                return None
    app.status_update("Found data file:")
    app.status_update(path)    
    f = open(path, "r")
    g = f.readlines()
    f.close()

    setting = ""
    rules = {}    
    for line in g:
        ls = line.strip()
        if not ls:
            continue
        if ls.find("applicatorSetting=") != -1:
            setting = ls.replace("applicatorSetting=","")
            rules[setting] = []
        else:
            if rules.has_key(setting):
                rules[setting].append(ls)
    g = []
    return rules

def pose_reader(pathPose):
    """
    """    
    path,ext = os.path.splitext(pathPose)
    if ext == ".crz" or ext == ".CRZ":
        f = gzip.GzipFile(pathPose)
    else:
        f = open(pathPose,"r")
    g = f.readlines()
    f.close()

    acts = []    
    affectors = []
    fignum = ""
    for num,line in enumerate(g):
        lt = line.strip().split()
        if not lt:
            continue
        if lt[0] == "actor":
            checkline = g[num+1].strip().split()
            if checkline and (not checkline[0] == "storageOffset") and (not checkline[0] == "geomCustom") and\
                   (not checkline[0] == "}"):
                checknum = line.replace("\n","").replace("\r","").split(":")[1]
                if checknum: # Rare case involving a figure freshly-created using the .phi process, or a hacked .cr2, will lack a figure number                    
                    if not fignum:
                        fignum = checknum
                    if checknum != fignum:
                        continue
                intname = line.strip().replace("actor ","")               
                num2 = 0
                while 1:
                    num2 += 1
                    lt2 = g[num+num2].strip().split()
                    if not lt2:
                        continue
                    if lt2[0] == "actor" or lt2[0] == "channels":                                                   
                        break
                    elif lt2[0] == "weightMap":                        
                        if not intname in acts:
                            acts.append(intname)                            
                        break
                    elif g[num+num2].replace("\n","").replace("\r","") == "\t}": # End of actor block reached
                        break
               
        elif ((lt[0][:-1] == "twist") or (lt[0][:-1] == "joint")):                        
            if (lt[1][:-1] != "twist") and (lt[1][:-1] != "joint"):                
                num2 = 1
                nextline = g[num+num2]
                stopline = nextline.replace("{","}")
                otherAct = ""
                while nextline != stopline:
                    nextline = g[num+num2]
                    nextlt = nextline.strip().split()
                    if nextlt[0] == "otherActor":
                        otherAct = nextline.strip().replace("\t"," ").replace("otherActor ","")
                        break
                    num2 += 1
                if otherAct:
                    name = otherAct.split(":")[0]
                    if not name in affectors:
                        affectors.append(name)                
                 
    g = []    
    return acts, affectors 

def check_gzip(dataPath):
    """
    Determine whether a file is gzipped, by checking for its 'magic number'.
    """
    f = open(dataPath,"rb")
    magic = f.read(2)    
    f.close()
    if magic == '\037\213': return 1
    else: return 0

class figure(object):
    """
    """
    def __init__(self):
        self.version = "version\n\t{\n\tnumber 9\n\t}\n"
        self.fignum = ""
        self.figRes = ""
        self.geomAct = {}
        self.geomProp = []
        self.parmAct = []
        self.actnames = []
        self.parmProp = []
        self.figTop = []
        self.figAdd = []
        self.figMid = []
        self.figWeld = []
        self.figBottom = []
        self.footer = []

    def check_fignum(self,actline):
        checknum = actline.replace("\n","").split(":")[1]        
        if not checknum:
            return 0
        if not self.fignum:
            self.fignum = checknum
            return 1
        if checknum != self.fignum:            
            return 0
        else:
            return 1   

class actor(object):
    """
    """
    def __init__(self):
        self.intname = ""
        self.name = ""
        self.animO = ""
        self.top = []
        self.weights = []
        self.chans = None
        self.origin = ""
        self.endpoint = ""
        self.orientation = ""
        self.bottom = []

class channels(object):
    """
    """
    def __init__(self):
        self.top = []
        self.affects = []
        self.mid = []
        self.offA = []
        self.joints = []
        self.bottom = []

def writer(pathFile,fig):
    f = open(pathFile,"w")
    f.write("{\n")
    f.write(fig.version)
    f.write(fig.figRes)    
    for act in fig.actnames:       
        for line in fig.geomAct[act]:
            f.write(line)
    for line in fig.geomProp:
        f.write(line)
    f.write(fig.figRes)    
    for act in fig.parmAct:        
        f.write("actor %s\n\t{\n" %(act.intname))
        for line in act.top:
            if line.find("animatableOrigin") != -1:
                f.write("\tanimatableOrigin %s\n" %(act.animO))
            else:
                f.write(line)
        for line in act.weights:
            f.write(line)
        for line in act.chans.top:            
            f.write(line)
        for line in act.chans.affects:
            f.write(line)
        for line in act.chans.offA:
            f.write(line)
        for line in act.chans.mid:
            f.write(line)
        for line in act.chans.joints:
            f.write(line)
        for line in act.chans.bottom:
            f.write(line)
        f.write(act.endpoint)
        f.write(act.origin)
        f.write(act.orientation)
        for line in act.bottom:
            f.write(line)
    for line in fig.parmProp:
        f.write(line)
    for line in fig.figTop:
        f.write(line)
    for line in fig.figAdd:
        f.write(line)
    for line in fig.figMid:
        f.write(line)
    for line in fig.figWeld:
        f.write(line)
    for line in fig.figBottom:
        f.write(line)
    for line in fig.footer:
        f.write(line)
    f.close()

def merger(pathFile,fig,useWeights=0,useJoints=0,useAffects=0,remove_JCM=1,remove_JSM=1,affectors=None,replace_fignum=0,intnames=None,rules=None,addBlock=0,useUnknown=0):    
    check = check_gzip(pathFile) # If Poser is set to save compressed files, it will have saved as .crz even if a .cr2 extension was given in the save path
    if check:
        f = gzip.GzipFile(pathFile)
    else:
        f = open(pathFile,"r")
    g = f.readlines()
    f.close()
    
    if replace_fignum: # Replace all figure number references in poses to make them consistent with cr2.
        num = "-1"
        for i in range(len(g)):
            line = g[i].replace("\r","\n")
            lt = line.strip().split()
            if num == "-1":
                if lt[0] == "actor":
                    if line.find(":") != -1:
                        num = lt[len(lt)-1].split(":")[1]                        
            if line.find(":%s" %(num)) != -1:
                g[i] = line.replace(":%s" %(num),":%s" %(fig.fignum))                
            elif lt[0] == "Figure" and line.find(num) != -1:
                g[i] = line.replace(num,fig.fignum)

    if not rules:
        rules = {}
    rules_keys = ["targetGeom_delete","targetGeom_preserve","valueParm_delete","valueParm_preserve","figname_append","figname_replace"]
    for rule in rules_keys:
        if not rule in rules.keys():
            rules[rule] = []
 
    depth = 0
    prevline = ""
    
    newact = None
    newchans = None
    
    actdepth = 2
    channeldepth = 3
    parmdepth = 4    

    ischannels = 0
    isfigure = 0
    blockType = ""    
    proptypes = ["prop","baseProp","magnetDeformerProp","sphereZoneProp","hairProp","waveDeformerProp"]
    injecting = 0
    inject_fig = 0
    not_in_pose = 0
    intname = ""
    
    for num,line in enumerate(g):
        line = line.replace("\r","\n")
        numtabs = line.count("\t")
        ls = line.strip()
        lt = ls.split()        
        if not lt:
            continue
        if addBlock == 1:
            if lt[0] == "actor":
                intname = "%s:%s" %(line.strip().replace("actor ","").split(":")[0],fig.fignum)                
            if (intname != "") and (not intname in fig.actnames):            
                continue
        # Handle opening brackets
        if lt[0] == "{":
            depth += 1            
            prev_lt = prevline.strip().replace("\t"," ").split()
            if not prev_lt:
                continue
            if prev_lt[0] == "actor":
                good = fig.check_fignum(prevline) # Limit processing to only the first figure in the .cr2
                if not good:                    
                    continue
                checkline = g[num+1].strip().split()
                if checkline and (not checkline[0] == "storageOffset") and (not checkline[0] == "geomCustom") and\
                   (not checkline[0] == "}"): # Separate handling for actor geom listings and parm listings
                    intname = "%s:%s" %(prevline.strip().replace("actor ","").split(":")[0],fig.fignum)                    
                    if (addBlock == 1) and (intname != "") and (not intname in fig.actnames):                        
                        continue
                    not_in_pose = 0
                    if intnames:
                        if not intname in intnames:
                            not_in_pose = 1
                    if intname in fig.actnames:                        
                        newact = fig.parmAct[fig.actnames.index(intname)]
                        injecting = 1                        
                    else:
                        newact = actor()
                        newact.intname = intname
                        fig.actnames.append(newact.intname)
                        injecting = 0                        
                else:
                    intname = "%s:%s" %(prevline.strip().replace("actor ","").split(":")[0],fig.fignum)                    
                    if (addBlock == 1) and (intname != "") and (not intname in fig.actnames):                       
                        continue
                    blockType = "geomAct"                    
                    fig.geomAct[intname] = [prevline]
            elif prev_lt[0] in proptypes:
                good = fig.check_fignum(prevline) # Limit processing to only the first figure in the .cr2
                if not good:                    
                    continue
                checkline = g[num+1].strip().split()
                if checkline and ((checkline[0] == "storageOffset") or (checkline[0] == "geomCustom")):
                    blockType = "geomProp"
                    fig.geomProp.append(prevline)
                else:
                    blockType = "parmProp"
                    fig.parmProp.append(prevline)

            elif prev_lt[0] == "figure":
                if not fig.figTop:
                    blockType = "figTop"
                    fig.figTop.append(prevline)
                    inject_fig = 0
                else:
                    inject_fig = 1
                isfigure = 1

            elif prev_lt[0] == "hairGrowthGroup":
                blockType = "footer"
                fig.footer.append(prevline)

            elif prev_lt[0] == "clothSimulator":
                blockType == "footer"
                fig.footer.append(prevline)
                
                    
            if (depth > actdepth) and (newact != None): # An actor's parameter block has been found.                    
                if prev_lt[0] == "weightMap":                    
                    if useWeights:                        
                        blockType = "weights"
                        newact.weights.append(prevline) # Handle weightMap section as solid block
                                            
                if prev_lt[0] == "channels":
                    ischannels = 1                    
                    if not injecting:                        
                        newchans = channels()
                        newchans.top.append(prevline)                        
                        newchans.top.append(line)
                    else:
                        newchans = newact.chans
                    
                if ischannels:
                    if prev_lt[0] == "groups":
                        blockType = "chansTop"
                        newchans.top.append(prevline)
                        
                    elif prev_lt[0] == "targetGeom":
                        if not not_in_pose:
                            name = prevline.strip().replace("\t"," ").replace("targetGeom ","")                            
                            if not (name in rules["targetGeom_preserve"]):                                
                                remove_this = 0
                                for partialName in rules["targetGeom_delete"]:
                                    if name.find(partialName) != -1:
                                        remove_this = 1
                                        break
                                if remove_this:                                    
                                    continue
                                if remove_JCM:
                                    if prevline.find("JCM") != -1:
                                        continue
                                if remove_JSM:
                                    if prevline.find("JSM") != -1:
                                        continue
                        blockType = "chansTop"
                        newchans.top.append(prevline)
                        
                    elif prev_lt[0] == "valueParm":                        
                        name = prevline.strip().replace("\t"," ").replace("valueParm ","")                        
                        if not name in rules["valueParm_preserve"]:
                            remove_this = 0
                            for partialName in rules["valueParm_delete"]:
                                if name.find(partialName) != -1:
                                    remove_this = 1
                                    break
                            if remove_this:                                
                                continue                            
                        blockType = "chansTop"
                        newchans.top.append(prevline)

                    elif prev_lt[0] == "deformerPropChan":
                        blockType = "chansTop"
                        newchans.top.append(prevline)

                    elif prev_lt[0][:-1] == "taper":
                        blockType = "chansTop"
                        newchans.top.append(prevline)
                        
                    elif prev_lt[0][:-1] == "smoothScale": # Include smoothScales with joint affector listings
                        if not_in_pose:
                            blockType = "affects"                                
                            newchans.affects.append(prevline)
                        else:
                            if useAffects:
                                if not affectors:                                
                                    blockType = "affects"                                
                                    newchans.affects.append(prevline) # Other actor joint affector listings
                                else:
                                    name = prev_lt[1].split("_")[0]                                
                                    if name in affectors: # Only remove otherActor references if they are also listed in the pose
                                        continue
                                    else:                                        
                                        blockType = "affects"                                
                                        newchans.affects.append(prevline)
                        
                    elif ((prev_lt[0][:-1] == "twist") or (prev_lt[0][:-1] == "joint")):                        
                        if (prev_lt[1][:-1] == "twist") or (prev_lt[1][:-1] == "joint"):
                            if useJoints or not_in_pose:
                                blockType = "joints"                                
                                newchans.joints.append(prevline) # The actor's own joints
                        else:
                            if not_in_pose:
                                blockType = "affects"                                
                                newchans.affects.append(prevline)
                            else:
                                if useAffects:
                                    if not affectors:                                    
                                        blockType = "affects"                                
                                        newchans.affects.append(prevline) # Other actor joint affector listings
                                    else:
                                        name = prev_lt[1].split("_")[0]                                    
                                        if name in affectors: # Only remove otherActor references if they are also listed in the pose
                                            continue
                                        else:                                            
                                            blockType = "affects"                                
                                            newchans.affects.append(prevline)
                            
                    elif ((prev_lt[0] == "scale") or (prev_lt[0][:-1] == "scale") or\
                          (prev_lt[0] == "propagatingScale") or (prev_lt[0][:-1] == "propagatingScale")):                                                    
                        blockType = "chansMid"
                        newchans.mid.append(prevline)
                    
                    elif prev_lt[0][1:] == "OffsetA":                                              
                        newchans.offA.append(prevline)
                        blockType = "chansOffA"                        
                        
                    elif prev_lt[0][1:] == "OffsetB":                        
                        blockType = "chansBottom"
                        newchans.bottom.append(prevline)
                        
                    elif prev_lt[0][:-1] == "rotate":                        
                        blockType = "chansBottom"
                        newchans.bottom.append(prevline)
                        
                    elif prev_lt[0][:-1] == "translate":                        
                        blockType = "chansBottom"
                        newchans.bottom.append(prevline)                    
                    else:
                        if useUnknown:
                            blockType = "chansBottom"
                            newchans.bottom.append(prevline)
                        else:
                            pass
                        
        # Handle closing brackets
        elif lt[0] == "}":
            depth -= 1
            if blockType == "joints" and depth < parmdepth:                
                newchans.joints.append(line)
                blockType = ""
            elif blockType == "affects" and depth < parmdepth:
                newchans.affects.append(line)
                blockType = ""
            elif blockType == "chansTop" and depth < parmdepth:                
                newchans.top.append(line)
                blockType = ""
            elif blockType == "chansMid" and depth < parmdepth:
                newchans.mid.append(line)
                blockType = ""
            elif blockType == "chansOffA" and depth < parmdepth:
                newchans.offA.append(line)
                blockType = ""
            elif blockType == "chansBottom" and depth < parmdepth:
                newchans.bottom.append(line)
                blockType = ""
                                 
            if blockType == "weights" and depth < channeldepth:                
                newact.weights.append(line)
                blockType = ""            
            elif blockType == "actBottom" and depth < actdepth:
                newact.bottom.append(line)
                blockType = ""
            if ischannels and depth < channeldepth:
                ischannels = 0
                if not injecting:
                    newchans.bottom.append(line)
                    newact.chans = newchans
                newchans = None                    
            if newact != None and depth < actdepth:
                if not injecting:
                    fig.parmAct.append(newact)
                newact = None                
            elif blockType == "parmProp" and depth < actdepth:
                fig.parmProp.append(line)
                blockType = ""
            elif blockType == "geomAct" and depth < actdepth:                
                fig.geomAct[intname].append(line)
                blockType = ""
            elif blockType == "geomProp" and depth < actdepth:                
                fig.geomProp.append(line)
                blockType = ""
            elif isfigure and depth < actdepth:
                isfigure = 0
                if not inject_fig:
                    fig.figBottom.append(line)
                blockType = ""
            elif blockType == "footer" and depth < actdepth:
                fig.footer.append(line)
                blockType = ""

        # Handle actor block variables        
        if depth == actdepth:
            if newact != None:
                if lt[0] == "name":                
                    newact.name = line
                    blockType = "actTop"
                elif lt[0] == "animatableOrigin":
                    newact.animO = line
                    if injecting and lt[1] == "1":
                        newact.chans.offA = [] # Requires that ALL THREE OffsetA parameters be included in pose to activate animatable origins for that actor.
                    blockType = "actTop"
                elif lt[0] == "weightMap":
                    blockType = ""
                elif lt[0] == "channels":
                    if blockType == "actTop":
                        blockType = ""
                elif lt[0] == "endPoint":
                    newact.endpoint = line
                elif lt[0] == "origin":
                    newact.origin = line
                elif lt[0] == "orientation":
                    newact.orientation = line
                elif lt[0] == "displayOrigin":
                    blockType = "actBottom"                
            if isfigure:
                if lt[0] == "name":
                    if rules["figname_replace"]:
                        line = "%sname %s\n" %("\t"*actdepth,rules["figname_replace"][0])
                    elif rules["figname_append"]:
                        line = "%s%s%s\n" %("\t"*actdepth,line.replace("\n","").replace("\r",""),rules["figname_append"][0])
                if lt[0] == "root" or lt[0] == "addChild":                    
                    blockType = "figAdd"                    
                elif lt[0] == "inkyChain":
                    blockType = "figMid"
                elif lt[0] == "defaultPick":
                    blockType = "figMid"
                elif lt[0] == "weld":
                    blockType = "figWeld"
                elif lt[0] == "allowsBending" or lt[0] == "figureType":
                    blockType = "figBottom"
                elif lt[0] == "material":
                    blocktype = "figBottom"
                elif lt[0] == "displayOn":
                    blockType = "figBottom"
                    
        elif depth < actdepth:
            if (not fig.figRes) and (lt[0] == "figureResFile"):
                fig.figRes = line
            if lt[0] == "setGeomHandlerOffset":
                blockType = "footer"               
            
        prevline = line # Store the previous line for reference when an opening bracket is found.
        
        if blockType == "joints":            
            newchans.joints.append(line)
        elif blockType == "affects":            
            newchans.affects.append(line)
        elif blockType == "weights":            
            newact.weights.append(line)
        elif blockType == "chansTop":
            newchans.top.append(line)
        elif blockType == "chansMid":
            newchans.mid.append(line)
        elif blockType == "chansOffA":
            newchans.offA.append(line)
        elif blockType == "chansBottom":
            newchans.bottom.append(line)
        elif blockType == "actTop":
            newact.top.append(line)                       
        elif blockType == "actBottom":
            newact.bottom.append(line)
        elif blockType == "parmProp":
            fig.parmProp.append(line)                            
        elif blockType == "geomAct":            
            fig.geomAct[intname].append(line)
        elif blockType == "geomProp":
            fig.geomProp.append(line)
        elif blockType == "figTop":
            if not inject_fig:
                fig.figTop.append(line)
        elif blockType == "figAdd":
            fig.figAdd.append(line)            
        elif blockType == "figMid":           
            fig.figMid.append(line)
        elif blockType == "figWeld":
            fig.figWeld.append(line)
        elif blockType == "figBottom":            
            fig.figBottom.append(line)
        elif blockType == "footer":
            fig.footer.append(line)

def deleteMags(fig,excludes,keep_specific=[],keep_general=[]):
    """
    """
    magnames = [a.InternalName() for a in fig.Actors() if a.IsDeformer()]    
    keepmags = []
    for name in keep_specific:
        keepmags.append(name)
    for name in magnames:
        for partialName in keep_general:        
            if not name in keepmags:
                if name.find(partialName) != -1:
                    keepmags.append(name)
    
    for actname in excludes:        
        act = fig.ActorByInternalName(actname)
        for parm in act.Parameters():
            if not parm.TypeCode() == poser.kParmCodeDEFORMERPROP:
                continue
            intname = parm.InternalName()
            if intname in magnames: # Assuming that deformer parm intname will match deformer intname.  May not always be true...?
                if not intname in keepmags:
                    keepmags.append(intname)    
    current_act = scene.CurrentActor()
    actors = [a for a in fig.Actors() if a.IsDeformer()]    
    for act in actors:        
        if not act.InternalName() in keepmags:            
            scene.SelectActor(act)
            scene.DeleteCurrentProp()
    scene.SelectActor(current_act)

def protect_naming(path):
    """Ensure unique file naming to avoid overwriting anything."""
    folder = os.path.dirname(path)
    filename = os.path.basename(path)    
    name,ext = os.path.splitext(filename)
    if os.path.exists(path):
        num = 0
        newname = "%s_%s%s" %(name,num,ext)
        while os.path.exists(os.path.join(folder,newname)):
            num += 1
            newname = "%s_%s%s" %(name,num,ext)
        return os.path.normpath(os.path.join(folder,newname))
    else:
        return path

class App(object):
    def __init__(self,master):
        self.master = master
        self.master.title("Weight Pose Applicator")

        self.pathDonor = ""
        self.pathTarget = ""
        self.pathBones = ""

        self.remVar = IntVar()
        self.remVar.set(1)
        self.tempVar = IntVar()
        self.tempVar.set(0)
        self.jcmVar = IntVar()
        self.jcmVar.set(1)
        self.jsmVar = IntVar()
        self.jsmVar.set(1)
        self.magVar = IntVar()
        self.magVar.set(1)

        #self.libDir = "."
        self.libDir = poser.ContentRootLocation() # Start browsing in library for version of Poser which is running the script

        self.masterFrame = Frame(self.master)
        self.masterFrame.grid(row=0, column=0)

        self.listFrame = Frame(self.masterFrame)
        self.listFrame.grid(row=0, column=0, padx=10)        

        self.mergeFrame = Frame(self.masterFrame)
        self.mergeFrame.grid(row=2, column=0)

        self.checkFrame = Frame(self.mergeFrame)
        self.checkFrame.grid(row=0, column=0, pady=10)

        self.buttonFrame = Frame(self.mergeFrame)
        self.buttonFrame.grid(row=1, column=0)

        self.listFrame2 = Frame(self.masterFrame)
        self.listFrame2.grid(row=3, column=0)

        self.labelDonor = Label(self.listFrame, text="Figure to have weights injected (.cr2 path)", anchor=N, justify=LEFT)
        self.labelDonor.grid(row=0, column=1)

        self.listDonor = Listbox(self.listFrame, height=1, width=116, selectmode=SINGLE, exportselection=0)
        self.listDonor.grid(row=1, column=1)

        self.labelTarget = Label(self.listFrame, text="Weight injection pose (.pz2 path)", anchor=N, justify=LEFT)
        self.labelTarget.grid(row=2,column=1)

        self.listTarget = Listbox(self.listFrame, height=1, width=116, selectmode=SINGLE, exportselection=0)
        self.listTarget.grid(row=3, column=1)

        self.labelBones = Label(self.listFrame, text="Optional pose containing new actors (.pz2 path)", anchor=N, justify=LEFT)
        self.labelBones.grid(row=4,column=1)

        self.listBones = Listbox(self.listFrame, height=1, width=116, selectmode=SINGLE, exportselection=0)
        self.listBones.grid(row=5, column=1)

        self.checkRem = Checkbutton(self.checkFrame, text="Delete temp files", variable=self.remVar)
        self.checkRem.grid(row=0, column=0, padx=15)

        self.checkTemp = Checkbutton(self.checkFrame, text="Use Poser temp location", variable=self.tempVar)
        self.checkTemp.grid(row=0, column=1, padx=15)

        self.checkJCM = Checkbutton(self.checkFrame, text="Remove JCM", variable=self.jcmVar)
        self.checkJCM.grid(row=0, column=2, padx=15)

        self.checkJSM = Checkbutton(self.checkFrame, text="Remove JSM", variable=self.jsmVar)
        self.checkJSM.grid(row=0, column=3, padx=15)

        self.checkMag = Checkbutton(self.checkFrame, text="Remove magnets", variable=self.magVar)
        self.checkMag.grid(row=0, column=4, padx=15)

        self.buttonDonor = Button(self.listFrame, text="...", command=self.browseDonor, padx=15)
        self.buttonDonor.grid(row=1, column=0, padx=5)     

        self.buttonTarget = Button(self.listFrame, text="...", command=self.browseTarget, padx=15)
        self.buttonTarget.grid(row=3, column=0, padx=5)

        self.buttonBones = Button(self.listFrame, text="...", command=self.browseBones, padx=15)
        self.buttonBones.grid(row=5, column=0, padx=5)

        self.buttonRun = Button(self.buttonFrame, text="Run script", command=self.runScript, padx=25)
        self.buttonRun.grid(row=1, column=0, padx=5, pady=10)

        self.buttonQuit = Button(self.buttonFrame, text="Quit Script", command=self.quitScript, padx=25)
        self.buttonQuit.grid(row=1, column=1, padx=5, pady=10)

        self.printScroll = Scrollbar(self.listFrame2, orient=VERTICAL)
        self.printScroll.grid( row=0, column=1,sticky=N+S+E)
        self.printList = Listbox(self.listFrame2, height=10, width=116, selectmode=SINGLE, exportselection=0, yscrollcommand=self.printScroll.set)
        self.printList.grid(row=0, column=0, pady=5)
        self.printScroll["command"] = self.printList.yview
        

        self.listDonor.insert(END,"") # Tk throws an error when deleting an empty listbox (?!?); add a dummy entry, to avoid this.
        self.listTarget.insert(END,"")
        self.listBones.insert(END,"")

    def status_update(self,line):
        self.printList.insert(END,line)
        self.printList.update()
        self.printList.see(END)

    def quitScript(self):        
        root.destroy()
        root.quit()
        scene.DrawAll()

    def runScript(self):        
        if (not self.pathDonor) or (not self.pathTarget):
            print "This script requires that both paths be defined.  Please try again."
            return
        load_cr2(self.pathDonor,self.pathTarget,self.pathBones,remove_files=self.remVar.get(),write_to_temp=self.tempVar.get(),
                 remove_JCM=self.jcmVar.get(),remove_JSM=self.jsmVar.get(),remove_mags=self.magVar.get())        
        scene.DrawAll()

    def relative_path(self,path):
        path = os.path.normpath(path)
        path = path.replace(os.sep,":")
        path = path.split("Runtime:Libraries")[1]
        path = ":Runtime:Libraries%s" %(path)        
        return path        

    def browseDonor(self):
        p = tkFileDialog.askopenfilename(initialdir=self.libDir, title="Locate target .cr2", filetypes=[("Poser Character File", "*.cr2 *.crz *.CR2 *.CRZ")])        
        if not p:
            return        
        self.listDonor.insert(0, p)
        self.pathDonor = p        

    def browseTarget(self):
        p = tkFileDialog.askopenfilename(initialdir=self.libDir, title="Locate weight pose", filetypes=[("Poser Pose File", "*.pz2 *.p2z *.PZ2 *.P2Z")])
        if not p:
            return        
        self.listTarget.insert(0, p)
        self.pathTarget = p

    def browseBones(self):
        p = tkFileDialog.askopenfilename(initialdir=self.libDir, title="Locate actors pose", filetypes=[("Poser Pose File", "*.pz2 *.p2z *.PZ2 *.P2Z")])
        if not p:
            return        
        self.listBones.insert(0, p)
        self.pathBones = p


root = Tk()
app = App(root)
root.mainloop()
